//
//  GSEmotionEscape.h
//  GSCommonKit
//
//  Created by net263 on 2019/8/12.
//  Copyright © 2019 gensee. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "GSSensitiveWord.h"
#import "GSChatItem.h"
NS_ASSUME_NONNULL_BEGIN

@interface GSChatContentParse : NSObject
@property (nonatomic, strong) NSDictionary *key2file; //emotion\emotion.smile.gif --> 微笑

@property (nonatomic, strong) NSDictionary *text2file; // 【微笑】--> emotion\emotion.smile.gif

@property (nonatomic, strong) NSDictionary *text2key; //【微笑】--> 微笑

@property (nonatomic, strong) NSMutableDictionary *emotionsData;

+ (GSChatContentParse *)sharedInstance;

// <IMG src="emotion\emotion.qq.gif" custom="false"> --> attachment + text
- (NSMutableAttributedString *) attributeStringFromHtml:(NSString *)html
                                        textFont:(UIFont*)font
                                       imageType:(NSString * _Nullable)type;

// 【表情】--> <IMG src="emotion\emotion.qq.gif" custom="false">
- (NSString *)htmlFromEmotionText:(NSString *)emotion;
/// 没有转义的
- (NSString *)htmlFromEmotionTextWithoutTrans:(NSString *)emotion;
//加入敏感词过滤
- (void)htmlFromEmotionTextWordFilter:(NSString *)emotion block:(void(^)(NSString* wordFilter, NSString* html))block;

// 加入敏感词过滤 没有对特殊符号转义的
- (void)htmlFromEmotionTextWordFilterWithoutTrans:(NSString *)emotion block:(void(^)(NSString* wordFilter, NSString* html))block;

+ (BOOL)stringContainsEmoji:(NSString *)string;

-(NSArray*) allEmotions;

- (NSArray *)all36Emotions;

//富文本拆分返回数组，表情对应为image
-(NSArray<GSChatItem*>*)arrayFromHtml:(NSString *)html;

@end

NS_ASSUME_NONNULL_END
